/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.overlay.components;

import com.google.common.annotations.VisibleForTesting;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.regex.Pattern;
import net.runelite.api.IndexedSprite;
import net.runelite.client.ui.overlay.components.BackgroundComponent;
import net.runelite.client.ui.overlay.components.ComponentConstants;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.TextComponent;

public class TooltipComponent
implements LayoutableRenderableEntity {
    private static final Pattern BR = Pattern.compile("</?br>");
    private static final int OFFSET = 4;
    private static final int MOD_ICON_WIDTH = 13;
    private String text;
    private Color backgroundColor = ComponentConstants.STANDARD_BACKGROUND_COLOR;
    private Point position = new Point();
    private IndexedSprite[] modIcons;

    @Override
    public Dimension render(Graphics2D graphics) {
        String[] lines;
        FontMetrics metrics = graphics.getFontMetrics();
        int textDescent = metrics.getDescent();
        int textHeight = metrics.getHeight();
        int tooltipWidth = 0;
        int tooltipHeight = 0;
        for (String line : lines = BR.split(this.text)) {
            int textWidth = TooltipComponent.calculateTextWidth(metrics, line);
            if (textWidth > tooltipWidth) {
                tooltipWidth = textWidth;
            }
            tooltipHeight += textHeight;
        }
        int x2 = this.position.x;
        int y2 = this.position.y;
        Rectangle tooltipBackground = new Rectangle(x2, y2, tooltipWidth + 8, tooltipHeight + 8);
        BackgroundComponent backgroundComponent = new BackgroundComponent();
        backgroundComponent.setBackgroundColor(this.backgroundColor);
        backgroundComponent.setRectangle(tooltipBackground);
        backgroundComponent.render(graphics);
        graphics.setColor(Color.WHITE);
        int textX = x2 + 4;
        int textY = y2 + 4;
        Color nextColor = Color.WHITE;
        for (int i2 = 0; i2 < lines.length; ++i2) {
            int lineX = textX;
            String line = lines[i2];
            char[] chars = line.toCharArray();
            int begin = 0;
            boolean inTag = false;
            for (int j2 = 0; j2 < chars.length; ++j2) {
                String argument;
                if (chars[j2] == '<') {
                    TextComponent textComponent = new TextComponent();
                    textComponent.setColor(nextColor);
                    String text = line.substring(begin, j2);
                    textComponent.setText(text);
                    textComponent.setPosition(new Point(lineX, textY + (i2 + 1) * textHeight - textDescent));
                    textComponent.render(graphics);
                    lineX += metrics.stringWidth(text);
                    begin = j2;
                    inTag = true;
                    continue;
                }
                if (chars[j2] != '>' || !inTag) continue;
                String subLine = line.substring(begin + 1, j2);
                if (subLine.startsWith("col=")) {
                    argument = subLine.substring(4);
                    nextColor = Color.decode("#" + argument);
                } else if (subLine.equals("/col")) {
                    nextColor = Color.WHITE;
                } else if (subLine.startsWith("img=")) {
                    if (this.modIcons != null) {
                        argument = subLine.substring(4);
                        int iconId = Integer.parseInt(argument);
                        IndexedSprite modIcon = this.modIcons[iconId];
                        this.renderModIcon(graphics, lineX, textY + i2 * textHeight - textDescent, modIcon);
                        lineX += modIcon.getWidth();
                    }
                } else {
                    TextComponent textComponent = new TextComponent();
                    textComponent.setColor(nextColor);
                    String text = line.substring(begin, j2 + 1);
                    textComponent.setText(text);
                    textComponent.setPosition(new Point(lineX, textY + (i2 + 1) * textHeight - textDescent));
                    textComponent.render(graphics);
                    lineX += metrics.stringWidth(text);
                }
                begin = j2 + 1;
                inTag = false;
            }
            TextComponent textComponent = new TextComponent();
            textComponent.setColor(nextColor);
            textComponent.setText(line.substring(begin));
            textComponent.setPosition(new Point(lineX, textY + (i2 + 1) * textHeight - textDescent));
            textComponent.render(graphics);
        }
        return new Dimension(tooltipWidth + 8, tooltipHeight + 8);
    }

    @VisibleForTesting
    static int calculateTextWidth(FontMetrics metrics, String line) {
        char[] chars = line.toCharArray();
        int textWidth = 0;
        int begin = 0;
        boolean inTag = false;
        for (int j2 = 0; j2 < chars.length; ++j2) {
            if (chars[j2] == '<') {
                textWidth += metrics.stringWidth(line.substring(begin, j2));
                begin = j2;
                inTag = true;
                continue;
            }
            if (chars[j2] != '>' || !inTag) continue;
            String subLine = line.substring(begin + 1, j2);
            if (subLine.startsWith("img=")) {
                textWidth += 13;
            } else if (!subLine.startsWith("col=") && !subLine.startsWith("/col")) {
                textWidth += metrics.stringWidth(line.substring(begin, j2 + 1));
            }
            begin = j2 + 1;
            inTag = false;
        }
        return textWidth += metrics.stringWidth(line.substring(begin));
    }

    private void renderModIcon(Graphics2D graphics, int x2, int y2, IndexedSprite modIcon) {
        int sourceOffset = 0;
        for (int y22 = 0; y22 < modIcon.getHeight(); ++y22) {
            for (int x22 = 0; x22 < modIcon.getWidth(); ++x22) {
                int index = modIcon.getPixels()[sourceOffset++] & 0xFF;
                if (index == 0) continue;
                graphics.setColor(new Color(modIcon.getPalette()[index]));
                graphics.drawLine(x2 + x22, y2 + y22, x2 + x22, y2 + y22);
            }
        }
    }

    @Override
    public Rectangle getBounds() {
        return null;
    }

    @Override
    public void setPreferredLocation(Point position) {
        this.position = position;
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public void setModIcons(IndexedSprite[] modIcons) {
        this.modIcons = modIcons;
    }
}

